import numpy as np
import matplotlib.pyplot as plt

# Параметры времени и спирали
t = np.linspace(9, 13, 400)  # Сколько витков
growth_rate = 0.4           # Быстрый рост
radius = np.exp(growth_rate * t)
x = radius * np.cos(2 * np.pi * t)
y = radius * np.sin(2 * np.pi * t)
z = t - 2
z_min = 6

# Фигура
fig = plt.figure(figsize=(8, 6))
ax = fig.add_subplot(111, projection='3d')
ax.plot(x, y, z, color='royalblue', linewidth=2)

# Убираем сетку и фон
ax.grid(False)
for spine in [ax.xaxis, ax.yaxis, ax.zaxis]:
   spine.pane.fill = False  # Прозрачный фон
   spine.line.set_color((1.0, 1.0, 1.0, 0.0))  # Прозрачные стандартные оси

# Настройка пределов и соотношения
max_r = np.max(radius)
x_range = max_r * 2.5
y_range = max_r * 2.5
z_max = np.max(z)

ax.set_xlim(-x_range, x_range)
ax.set_ylim(-y_range, y_range)
ax.set_zlim(0, z_max)

# Убираем метки
ax.set_xticks([])
ax.set_yticks([])
ax.set_zticks([])

# Рисуем центральные оси
ax.plot([-x_range, x_range], [0, 0], [z_min, z_min], color='black', linewidth=1)  # x
ax.plot([0, 0], [-y_range, y_range], [z_min, z_min], color='black', linewidth=1)  # y
ax.plot([0, 0], [0, 0], [z_min, z_max], color='black', linewidth=1)               # t

# Подписи осей
ax.text(x_range * 1.05, 0, z_min, r'$x$', fontsize=16)
ax.text(0, y_range * 1.05, z_min, r'$y$', fontsize=16)
ax.text(0, 0, z_max * 1.02, r'$t$', fontsize=16)

# Соотношение сторон
ax.set_box_aspect([1.5, 1.5, 2.0])

# Сохраняем изображение
plt.tight_layout()
plt.savefig("time_exponentiation_spiral_py.png", dpi=150)
# plt.show()
