// requires acanvas.js also
var HOSHEN_VERTEX_COLOR_1 = "#FF4000";
var HOSHEN_VERTEX_COLOR_2 = "#0000FF";
var HOSHEN_EDGE_COLOR_1 = "#FFFF00";
var HOSHEN_EDGE_COLOR_2 = "#FFFFFF";
var HOSHEN_EDGE_PENTAGRAM_COLOR_1 = "#FF4000";
var HOSHEN_EDGE_PENTAGRAM_COLOR_2 = "#0080FF";
var HOSHEN_INTERMEDIATE_EDDES = [
    1, 6+2,
    1, 6+5,
    2, 6+3,
    2, 6+1,
    3, 6+5,
    3, 6+4,
    4, 6+3,
    4, 6+2,
    5, 6+4,
    5, 6+1
];
var HOSHEN_PENTAGRAMM_EDDES_1 = [
    1, 3,
    3, 5,
    5, 2,
    2, 4,
    4, 1
]
var HOSHEN_PENTAGRAMM_EDDES_2 = [
    6+1, 6+3,
    6+3, 6+5,
    6+5, 6+2,
    6+2, 6+4,
    6+4, 6+1
]

function drawHoshenVertex(context, hoshenVertices, index, color, large) {
    var v = hoshenVertices[index];
    fillCircle(context, v.x, v.y, large ? 12 : 10, color);
}

function drawHoshenEdge(context, hoshenVertices, index1, index2, color) {
    var v1 = hoshenVertices[index1];
    var v2 = hoshenVertices[index2];
    context.strokeStyle = color;
    drawLine(context, v1.x, v1.y, v2.x, v2.y);
}

function drawHoshenAttributes(context, hoshenVertices, iteration) {
    var stage = 0, step = 0;
    if (iteration < 5) {
        stage = 0;
    } else if (iteration < 10) {
        stage = 1;
    } else if (iteration < 15) {
        stage = 2; step = iteration - 10;
    } else if (iteration < 30) {
        stage = 3;
    } else if (iteration < 35) {
        stage = 4;
    } else if (iteration < 55) {
        stage = 5;
    } else if (iteration < 60) {
        stage = 6;
    } else if (iteration < 65) {
        stage = 7; step = iteration - 60;
    } else if (iteration < 80) {
        stage = 8;
    } else if (iteration < 85) {
        stage = 9;
    } else if (iteration < 90) {
        stage = 10;
    } else if (iteration < 95) {
        stage = 11;
    } else if (iteration < 105) {
        stage = 12; step = iteration - 105;
    } else {
        stage = 1000;
    }
    drawHoshenAttributesForStage(context, hoshenVertices, stage, step);
}

function drawHoshenAttributesForStage(context, hoshenVertices, stage, step) {
    if (stage == 0) {
        return;
    }
    context.lineWidth = 4;
    drawHoshenVertex(context, hoshenVertices, 0, HOSHEN_VERTEX_COLOR_1);
    if (stage == 1) {
        return;
    }
    for (var k = 1; k < (stage == 2 ? step : 6); k++) {
        drawHoshenEdge(context, hoshenVertices, 0, k, HOSHEN_EDGE_COLOR_1);
        drawHoshenVertex(context, hoshenVertices, k, HOSHEN_VERTEX_COLOR_1);
    }
    drawHoshenVertex(context, hoshenVertices, 0, HOSHEN_VERTEX_COLOR_1);
    if (stage == 2) {
        return;
    }
    context.lineWidth = 2;
    for (var k = 0; k < HOSHEN_PENTAGRAMM_EDDES_1.length; k += 2) {
        drawHoshenEdge(context, hoshenVertices,
            HOSHEN_PENTAGRAMM_EDDES_1[k], HOSHEN_PENTAGRAMM_EDDES_1[k + 1],
            HOSHEN_EDGE_PENTAGRAM_COLOR_1);
    }
    if (stage == 3) {
        return;
    }
    for (var k = 0; k < HOSHEN_INTERMEDIATE_EDDES.length; k += 2) {
        drawHoshenEdge(context, hoshenVertices,
            HOSHEN_INTERMEDIATE_EDDES[k], HOSHEN_INTERMEDIATE_EDDES[k + 1],
            HOSHEN_EDGE_COLOR_1);
    }
    for (var k = 0; k < HOSHEN_INTERMEDIATE_EDDES.length; k += 2) {
        drawHoshenVertex(context, hoshenVertices, HOSHEN_INTERMEDIATE_EDDES[k + 1], HOSHEN_VERTEX_COLOR_1);
    }
    if (stage == 4) {
        return;
    }
    for (var k = 7; k < 12; k++) {
        drawHoshenEdge(context, hoshenVertices, 6, k, HOSHEN_EDGE_COLOR_1);
    }
    drawHoshenVertex(context, hoshenVertices, 6, HOSHEN_VERTEX_COLOR_1);
    if (stage == 5) {
        return;
    }
    drawHoshenVertex(context, hoshenVertices, 6, HOSHEN_VERTEX_COLOR_2);
    if (stage == 6) {
        return;
    }
    context.lineWidth = 4;
    for (var k = 1; k < (stage == 7 ? step : 6); k++) {
        drawHoshenEdge(context, hoshenVertices, 6, 6 + k, HOSHEN_EDGE_COLOR_2);
        drawHoshenVertex(context, hoshenVertices, 6 + k, HOSHEN_VERTEX_COLOR_2);
    }
    drawHoshenVertex(context, hoshenVertices, 6, HOSHEN_VERTEX_COLOR_2);
    if (stage == 7) {
        return;
    }
    context.lineWidth = 2;
    for (var k = 0; k < HOSHEN_PENTAGRAMM_EDDES_2.length; k += 2) {
        drawHoshenEdge(context, hoshenVertices,
            HOSHEN_PENTAGRAMM_EDDES_2[k], HOSHEN_PENTAGRAMM_EDDES_2[k + 1],
            HOSHEN_EDGE_PENTAGRAM_COLOR_2);
    }
    if (stage == 8) {
        return;
    }
    for (var k = 0; k < HOSHEN_INTERMEDIATE_EDDES.length; k += 2) {
        drawHoshenEdge(context, hoshenVertices,
            HOSHEN_INTERMEDIATE_EDDES[k], HOSHEN_INTERMEDIATE_EDDES[k + 1],
            HOSHEN_EDGE_COLOR_2);
    }
    for (var k = 0; k < HOSHEN_INTERMEDIATE_EDDES.length; k += 2) {
        drawHoshenVertex(context, hoshenVertices, HOSHEN_INTERMEDIATE_EDDES[k], HOSHEN_VERTEX_COLOR_2);
    }
    if (stage == 9) {
        return;
    }
    context.lineWidth = 4;
    for (var k = 1; k < 6; k++) {
        drawHoshenEdge(context, hoshenVertices, 0, k, HOSHEN_EDGE_COLOR_2);
    }
    if (stage == 10) {
        return;
    }
    drawHoshenVertex(context, hoshenVertices, 0, HOSHEN_VERTEX_COLOR_2);
    if (stage == 11) {
        return;
    }
    for (var k = 0; k < 12; k++) {
        drawHoshenVertex(context, hoshenVertices, k,
            step % 2 == 0 ? "#FFFF00" : "#00C000", true);
    }
}
